package gov.va.med.mhv.usermgmt.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.common.data.model.InPersonAuthenticationLight;

@Repository
public interface InPersonAuthenticationLightRepository extends JpaRepository<InPersonAuthenticationLight, Long> {

	@Query("select ipa from InPersonAuthenticationLight ipa where ipa.mviAuthenticationStatus = 'PENDING_UNAUTH'")
	List<InPersonAuthenticationLight> getMVIPendingUnauthPatients();

	@Query("select ipa from InPersonAuthenticationLight ipa where ipa.patientId = :patientId")
	List<InPersonAuthenticationLight> getAuthenticationForPatient(@Param("patientId") Long patientId);

	@Query("select ipa from InPersonAuthenticationLight ipa where ipa.mviAuthenticationStatus = 'PENDING_UNAUTH'")
	List<InPersonAuthenticationLight> getMVIPendingAuthPatients();
}